/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBaseString;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.PyUnicode;
import org.python.core.StringSubsequenceIterator;
import org.python.core.imp;
import org.python.core.util.StringUtil;

public class codecs {
    public static final String BACKSLASHREPLACE = "backslashreplace";
    public static final String IGNORE = "ignore";
    public static final String REPLACE = "replace";
    public static final String XMLCHARREFREPLACE = "xmlcharrefreplace";
    private static char Py_UNICODE_REPLACEMENT_CHARACTER = (char)65533;
    private static PyList searchPath;
    private static PyStringMap searchCache;
    private static PyStringMap errorHandlers;
    private static final Object INIT_LOCK;
    private static String default_encoding;
    private static boolean import_encodings_called;
    static char[] hexdigits;
    public static char[] utf7_special;
    private static final String B64_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static byte[] utf8_code_length;
    private static char[] hexdigit;

    public static String getDefaultEncoding() {
        return default_encoding;
    }

    public static void setDefaultEncoding(String string) {
        codecs.lookup(string);
        default_encoding = string;
    }

    public static PyObject lookup_error(String string) {
        PyObject pyObject;
        codecs.registry_init();
        if (string == null) {
            string = "strict";
        }
        if ((pyObject = errorHandlers.__finditem__(string.intern())) == null) {
            throw new PyException(Py.LookupError, "unknown error handler name '" + string + "'");
        }
        return pyObject;
    }

    public static void register_error(String string, PyObject pyObject) {
        codecs.registry_init();
        if (!pyObject.isCallable()) {
            throw Py.TypeError("argument must be callable");
        }
        errorHandlers.__setitem__(string.intern(), pyObject);
    }

    public static void register(PyObject pyObject) {
        codecs.registry_init();
        if (!pyObject.isCallable()) {
            throw Py.TypeError("argument must be callable");
        }
        searchPath.append(pyObject);
    }

    public static PyTuple lookup(String string) {
        codecs.registry_init();
        PyString pyString = new PyString(codecs.normalizestring(string));
        PyObject pyObject = searchCache.__finditem__(pyString);
        if (pyObject != null) {
            return (PyTuple)pyObject;
        }
        if (searchPath.__len__() == 0) {
            throw new PyException(Py.LookupError, "no codec search functions registered: can't find encoding '" + string + "'");
        }
        for (PyObject pyObject2 : searchPath.asIterable()) {
            PyObject pyObject3 = pyObject2.__call__(pyString);
            if (pyObject3 == Py.None) continue;
            if (!(pyObject3 instanceof PyTuple) || pyObject3.__len__() != 4) {
                throw Py.TypeError("codec search functions must return 4-tuples");
            }
            searchCache.__setitem__(pyString, pyObject3);
            return (PyTuple)pyObject3;
        }
        throw new PyException(Py.LookupError, "unknown encoding '" + string + "'");
    }

    private static String normalizestring(String string) {
        return string.toLowerCase().replace(' ', '-');
    }

    private static void import_encodings() {
        block3: {
            if (!import_encodings_called) {
                import_encodings_called = true;
                try {
                    imp.load("encodings");
                }
                catch (PyException pyException) {
                    if (pyException.type == Py.ImportError) break block3;
                    throw pyException;
                }
            }
        }
    }

    public static PyObject decode(PyString pyString, String string, String string2) {
        PyObject pyObject;
        string = string == null ? codecs.getDefaultEncoding() : codecs.normalizestring(string);
        if (string2 != null) {
            string2 = string2.intern();
        }
        if (string.equals("ascii")) {
            return codecs.wrapDecodeResult(codecs.PyUnicode_DecodeASCII(pyString.toString(), pyString.__len__(), string2));
        }
        try {
            pyObject = codecs.lookup(string).__getitem__(1);
        }
        catch (PyException pyException) {
            if (pyException.match(Py.LookupError)) {
                if (string.equals("utf-8")) {
                    return codecs.wrapDecodeResult(codecs.PyUnicode_DecodeUTF8(pyString.toString(), string2));
                }
                if (string.equals("utf-7")) {
                    return codecs.wrapDecodeResult(codecs.PyUnicode_DecodeUTF7(pyString.toString(), string2));
                }
                if (string.equals("latin-1")) {
                    return codecs.wrapDecodeResult(codecs.PyUnicode_DecodeLatin1(pyString.toString(), pyString.__len__(), string2));
                }
            }
            throw pyException;
        }
        PyObject pyObject2 = string2 != null ? pyObject.__call__(pyString, (PyObject)new PyString(string2)) : pyObject.__call__(pyString);
        if (!(pyObject2 instanceof PyTuple) || pyObject2.__len__() != 2) {
            throw Py.TypeError("decoder must return a tuple (object,integer)");
        }
        return pyObject2.__getitem__(0);
    }

    private static PyUnicode wrapDecodeResult(String string) {
        return new PyUnicode(string, true);
    }

    public static String encode(PyString pyString, String string, String string2) {
        PyObject pyObject;
        string = string == null ? codecs.getDefaultEncoding() : codecs.normalizestring(string);
        if (string2 != null) {
            string2 = string2.intern();
        }
        if (string.equals("latin-1")) {
            return codecs.PyUnicode_EncodeLatin1(pyString.toString(), pyString.__len__(), string2);
        }
        if (string.equals("ascii")) {
            return codecs.PyUnicode_EncodeASCII(pyString.toString(), pyString.__len__(), string2);
        }
        try {
            pyObject = codecs.lookup(string).__getitem__(0);
        }
        catch (PyException pyException) {
            if (pyException.match(Py.LookupError)) {
                if (string.equals("utf-8")) {
                    return codecs.PyUnicode_EncodeUTF8(pyString.toString(), string2);
                }
                if (string.equals("utf-7")) {
                    return codecs.PyUnicode_EncodeUTF7(pyString.toString(), false, false, string2);
                }
            }
            throw pyException;
        }
        PyObject pyObject2 = string2 != null ? pyObject.__call__(pyString, (PyObject)new PyString(string2)) : pyObject.__call__(pyString);
        if (!(pyObject2 instanceof PyTuple) || pyObject2.__len__() != 2) {
            throw Py.TypeError("encoder must return a tuple (object,integer)");
        }
        PyObject pyObject3 = pyObject2.__getitem__(0);
        if (pyObject3 instanceof PyString) {
            return pyObject3.toString();
        }
        throw Py.TypeError("encoder did not return a string/unicode object (type=" + pyObject3.getType().fastGetName() + ")");
    }

    public static PyObject strict_errors(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser("strict_errors", pyObjectArray, stringArray, "exc");
        PyObject pyObject = argParser.getPyObject(0);
        if (Py.isInstance(pyObject, Py.UnicodeDecodeError)) {
            throw new PyException(Py.UnicodeDecodeError, pyObject);
        }
        if (Py.isInstance(pyObject, Py.UnicodeEncodeError)) {
            throw new PyException(Py.UnicodeEncodeError, pyObject);
        }
        if (Py.isInstance(pyObject, Py.UnicodeTranslateError)) {
            throw new PyException(Py.UnicodeTranslateError, pyObject);
        }
        throw codecs.wrong_exception_type(pyObject);
    }

    public static PyObject ignore_errors(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser("ignore_errors", pyObjectArray, stringArray, "exc");
        PyObject pyObject = argParser.getPyObject(0);
        if (!codecs.isUnicodeError(pyObject)) {
            throw codecs.wrong_exception_type(pyObject);
        }
        PyObject pyObject2 = pyObject.__getattr__("end");
        return new PyTuple(Py.java2py(""), pyObject2);
    }

    private static boolean isUnicodeError(PyObject pyObject) {
        return Py.isInstance(pyObject, Py.UnicodeDecodeError) || Py.isInstance(pyObject, Py.UnicodeEncodeError) || Py.isInstance(pyObject, Py.UnicodeTranslateError);
    }

    public static PyObject replace_errors(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser("replace_errors", pyObjectArray, stringArray, "exc");
        PyObject pyObject = argParser.getPyObject(0);
        if (Py.isInstance(pyObject, Py.UnicodeDecodeError)) {
            PyObject pyObject2 = pyObject.__getattr__("object");
            if (!Py.isInstance(pyObject2, PyString.TYPE) || Py.isInstance(pyObject2, PyUnicode.TYPE)) {
                throw Py.TypeError("object attribute must be str");
            }
            PyObject pyObject3 = pyObject.__getattr__("end");
            return new PyTuple(new PyUnicode(Py_UNICODE_REPLACEMENT_CHARACTER), pyObject3);
        }
        if (Py.isInstance(pyObject, Py.UnicodeEncodeError)) {
            PyObject pyObject4 = pyObject.__getattr__("object");
            if (!Py.isInstance(pyObject4, PyUnicode.TYPE)) {
                throw Py.TypeError("object attribute must be unicode");
            }
            PyObject pyObject5 = pyObject.__getattr__("end");
            return new PyTuple(Py.java2py("?"), pyObject5);
        }
        if (Py.isInstance(pyObject, Py.UnicodeTranslateError)) {
            PyObject pyObject6 = pyObject.__getattr__("end");
            return new PyTuple(new PyUnicode(Py_UNICODE_REPLACEMENT_CHARACTER), pyObject6);
        }
        throw codecs.wrong_exception_type(pyObject);
    }

    public static PyObject xmlcharrefreplace_errors(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser("xmlcharrefreplace_errors", pyObjectArray, stringArray, "exc");
        PyObject pyObject = argParser.getPyObject(0);
        if (!Py.isInstance(pyObject, Py.UnicodeEncodeError)) {
            throw codecs.wrong_exception_type(pyObject);
        }
        int n = ((PyInteger)pyObject.__getattr__("start")).getValue();
        int n2 = ((PyInteger)pyObject.__getattr__("end")).getValue();
        String string = pyObject.__getattr__("object").toString();
        StringBuilder stringBuilder = new StringBuilder();
        codecs.xmlcharrefreplace_internal(n, n2, string, stringBuilder);
        return new PyTuple(Py.java2py(stringBuilder.toString()), pyObject.__getattr__("end"));
    }

    public static StringBuilder xmlcharrefreplace(int n, int n2, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        codecs.xmlcharrefreplace_internal(n, n2, string, stringBuilder);
        return stringBuilder;
    }

    private static void xmlcharrefreplace_internal(int n, int n2, String string, StringBuilder stringBuilder) {
        for (int i = n; i < n2; ++i) {
            int n3;
            int n4;
            stringBuilder.append("&#");
            char c = string.charAt(i);
            if (c < '\n') {
                n4 = 1;
                n3 = 1;
            } else if (c < 'd') {
                n4 = 2;
                n3 = 10;
            } else if (c < '\u03e8') {
                n4 = 3;
                n3 = 100;
            } else if (c < '\u2710') {
                n4 = 4;
                n3 = 1000;
            } else if (c < '\u186a0') {
                n4 = 5;
                n3 = 10000;
            } else if (c < '\uf4240') {
                n4 = 6;
                n3 = 100000;
            } else {
                n4 = 7;
                n3 = 1000000;
            }
            while (n4-- > 0) {
                stringBuilder.append((char)(48 + c / n3));
                c = (char)(c % n3);
                n3 /= 10;
            }
            stringBuilder.append(';');
        }
    }

    private static PyException wrong_exception_type(PyObject pyObject) {
        PyObject pyObject2 = pyObject.__getattr__("__class__");
        PyObject pyObject3 = pyObject2.__getattr__("__name__");
        return new PyException(Py.TypeError, "Don't know how to handle " + pyObject3 + " in error callback");
    }

    public static PyObject backslashreplace_errors(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser("backslashreplace_errors", pyObjectArray, stringArray, "exc");
        PyObject pyObject = argParser.getPyObject(0);
        if (!Py.isInstance(pyObject, Py.UnicodeEncodeError)) {
            throw codecs.wrong_exception_type(pyObject);
        }
        int n = ((PyInteger)pyObject.__getattr__("start")).getValue();
        int n2 = ((PyInteger)pyObject.__getattr__("end")).getValue();
        String string = pyObject.__getattr__("object").toString();
        StringBuilder stringBuilder = new StringBuilder();
        codecs.backslashreplace_internal(n, n2, string, stringBuilder);
        return new PyTuple(Py.java2py(stringBuilder.toString()), pyObject.__getattr__("end"));
    }

    public static StringBuilder backslashreplace(int n, int n2, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        codecs.backslashreplace_internal(n, n2, string, stringBuilder);
        return stringBuilder;
    }

    private static void backslashreplace_internal(int n, int n2, String string, StringBuilder stringBuilder) {
        StringSubsequenceIterator stringSubsequenceIterator = new StringSubsequenceIterator(string, n, n2, 1);
        while (stringSubsequenceIterator.hasNext()) {
            int n3 = (Integer)stringSubsequenceIterator.next();
            stringBuilder.append('\\');
            if (n3 >= 65536) {
                stringBuilder.append('U');
                stringBuilder.append(hexdigits[n3 >> 28 & 0xF]);
                stringBuilder.append(hexdigits[n3 >> 24 & 0xF]);
                stringBuilder.append(hexdigits[n3 >> 20 & 0xF]);
                stringBuilder.append(hexdigits[n3 >> 16 & 0xF]);
                stringBuilder.append(hexdigits[n3 >> 12 & 0xF]);
                stringBuilder.append(hexdigits[n3 >> 8 & 0xF]);
            } else if (n3 >= 256) {
                stringBuilder.append('u');
                stringBuilder.append(hexdigits[n3 >> 12 & 0xF]);
                stringBuilder.append(hexdigits[n3 >> 8 & 0xF]);
            } else {
                stringBuilder.append('x');
            }
            stringBuilder.append(hexdigits[n3 >> 4 & 0xF]);
            stringBuilder.append(hexdigits[n3 & 0xF]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registry_init() {
        Object object = INIT_LOCK;
        synchronized (object) {
            String[] stringArray;
            if (searchPath != null) {
                return;
            }
            searchPath = new PyList();
            searchCache = new PyStringMap();
            errorHandlers = new PyStringMap();
            for (String string : stringArray = new String[]{"strict", IGNORE, REPLACE, XMLCHARREFREPLACE, BACKSLASHREPLACE}) {
                codecs.register_error(string, Py.newJavaFunc(codecs.class, string + "_errors"));
            }
            codecs.import_encodings();
        }
    }

    private static boolean SPECIAL(char c, boolean bl, boolean bl2) {
        return c > '\u007f' || utf7_special[c] == '\u0001' || bl2 && utf7_special[c] == '\u0002' || bl && utf7_special[c] == '\u0003';
    }

    private static char B64(int n) {
        return B64_CHARS.charAt(n & 0x3F);
    }

    private static boolean B64CHAR(char c) {
        return B64_CHARS.indexOf(c) != -1;
    }

    private static int UB64(char c) {
        return c == '+' ? 62 : (c == '/' ? 63 : (c >= 'a' ? c - 71 : (c >= 'A' ? c - 65 : c + 4)));
    }

    public static String PyUnicode_DecodeUTF7(String string, String string2) {
        int n = 0;
        int n2 = string.length();
        boolean bl = false;
        int n3 = 0;
        long l = 0L;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder(n2);
        while (n < n2) {
            char c = string.charAt(n);
            if (bl) {
                char c2;
                if (c == '-' || !codecs.B64CHAR(c)) {
                    bl = false;
                    ++n;
                    while (n3 >= 16) {
                        c2 = (char)(l >> (n3 -= 16) & 0xFFFFL);
                        if (bl2) {
                            n = codecs.insertReplacementAndGetResume(stringBuilder, string2, "utf-7", string, n, n + 1, "code pairs are not supported");
                            bl2 = false;
                            continue;
                        }
                        if ('\udc00' <= c2 && c2 <= '\udfff') {
                            bl2 = true;
                            continue;
                        }
                        stringBuilder.append(c2);
                    }
                    if (n3 >= 6) {
                        n = codecs.insertReplacementAndGetResume(stringBuilder, string2, "utf-7", string, n, n + 1, "partial character in shift sequence");
                    }
                    if (n3 > 0 && (l << 5 - n3 & 0x1FL) > 0L) {
                        n = codecs.insertReplacementAndGetResume(stringBuilder, string2, "utf-7", string, n, n + 1, "non-zero padding bits in shift sequence");
                    }
                    if (c == '-') {
                        if (n < n2 && string.charAt(n) == '-') {
                            stringBuilder.append('-');
                            bl = true;
                        }
                    } else if (codecs.SPECIAL(c, false, false)) {
                        n = codecs.insertReplacementAndGetResume(stringBuilder, string2, "utf-7", string, n, n + 1, "unexpected special character");
                    } else {
                        stringBuilder.append(c);
                    }
                } else {
                    l = l << 6 | (long)codecs.UB64(c);
                    n3 += 6;
                    ++n;
                    while (n3 >= 16) {
                        c2 = (char)(l >> (n3 -= 16) & 0xFFFFL);
                        if (bl2) {
                            n = codecs.insertReplacementAndGetResume(stringBuilder, string2, "utf-7", string, n, n + 1, "code pairs are not supported");
                            continue;
                        }
                        if ('\udc00' <= c2 && c2 <= '\udfff') {
                            bl2 = true;
                            continue;
                        }
                        stringBuilder.append(c2);
                    }
                }
            } else if (c == '+') {
                if (++n < n2 && string.charAt(n) == '-') {
                    ++n;
                    stringBuilder.append('+');
                } else {
                    bl = true;
                    n3 = 0;
                }
            } else if (codecs.SPECIAL(c, false, false)) {
                n = codecs.insertReplacementAndGetResume(stringBuilder, string2, "utf-7", string, n, n + 1, "unexpected special character");
            } else {
                stringBuilder.append(c);
                ++n;
            }
            if (!bl || n != n2) continue;
            n = codecs.insertReplacementAndGetResume(stringBuilder, string2, "utf-7", string, n, n, "unterminated shift sequence");
        }
        return stringBuilder.toString();
    }

    public static String PyUnicode_EncodeUTF7(String string, boolean bl, boolean bl2, String string2) {
        int n = string.length();
        if (n == 0) {
            return "";
        }
        boolean bl3 = false;
        int n2 = 0;
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!bl3) {
                if (c == '+') {
                    stringBuilder.append('+');
                    stringBuilder.append('-');
                    continue;
                }
                if (codecs.SPECIAL(c, bl, bl2)) {
                    n3 = c;
                    stringBuilder.append('+');
                    for (n2 = 16; n2 >= 6; n2 -= 6) {
                        stringBuilder.append(codecs.B64(n3 >> n2 - 6));
                    }
                    bl3 = n2 > 0;
                    continue;
                }
                stringBuilder.append(c);
                continue;
            }
            if (!codecs.SPECIAL(c, bl, bl2)) {
                stringBuilder.append(codecs.B64(n3 << 6 - n2));
                n3 = 0;
                n2 = 0;
                if (codecs.B64CHAR(c) || c == '-') {
                    stringBuilder.append('-');
                }
                bl3 = false;
                stringBuilder.append(c);
                continue;
            }
            n2 += 16;
            n3 = n3 << 16 | c;
            while (n2 >= 6) {
                stringBuilder.append(codecs.B64(n3 >> n2 - 6));
                n2 -= 6;
            }
            if (n2 != 0) continue;
            if (i + 1 < n) {
                char c2 = string.charAt(i + 1);
                if (codecs.SPECIAL(c2, bl, bl2)) continue;
                if (codecs.B64CHAR(c2) || c2 == '-') {
                    stringBuilder.append('-');
                    bl3 = false;
                    continue;
                }
                bl3 = false;
                continue;
            }
            stringBuilder.append('-');
            bl3 = false;
        }
        if (n2 > 0) {
            stringBuilder.append(codecs.B64(n3 << 6 - n2));
            stringBuilder.append('-');
        }
        return stringBuilder.toString();
    }

    public static String PyUnicode_DecodeUTF8(String string, String string2) {
        return codecs.PyUnicode_DecodeUTF8Stateful(string, string2, null);
    }

    public static String PyUnicode_DecodeUTF8Stateful(String string, String string2, int[] nArray) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        int n2 = 0;
        block7: while (n2 < n) {
            int n3 = string.charAt(n2);
            if (n3 < 128) {
                stringBuilder.append((char)n3);
                ++n2;
                continue;
            }
            if (n3 > 255) {
                n2 = codecs.insertReplacementAndGetResume(stringBuilder, string2, "utf-8", string, n2, n2 + 1, "ordinal not in range(255)");
                continue;
            }
            byte by = utf8_code_length[n3];
            if (n2 + by > n) {
                if (nArray != null) break;
                n2 = codecs.insertReplacementAndGetResume(stringBuilder, string2, "utf-8", string, n2, n2 + 1, "unexpected end of data");
                continue;
            }
            switch (by) {
                case 0: {
                    n2 = codecs.insertReplacementAndGetResume(stringBuilder, string2, "utf-8", string, n2, n2 + 1, "unexpected code byte");
                    continue block7;
                }
                case 1: {
                    n2 = codecs.insertReplacementAndGetResume(stringBuilder, string2, "utf-8", string, n2, n2 + 1, "internal error");
                    continue block7;
                }
                case 2: {
                    char c = string.charAt(n2 + 1);
                    if ((c & 0xC0) != 128) {
                        n2 = codecs.insertReplacementAndGetResume(stringBuilder, string2, "utf-8", string, n2, n2 + 2, "invalid data");
                        continue block7;
                    }
                    if ((n3 = ((n3 & 0x1F) << 6) + (c & 0x3F)) < 128) {
                        n2 = codecs.insertReplacementAndGetResume(stringBuilder, string2, "utf-8", string, n2, n2 + 2, "illegal encoding");
                        continue block7;
                    }
                    stringBuilder.appendCodePoint(n3);
                    break;
                }
                case 3: {
                    char c = string.charAt(n2 + 1);
                    char c2 = string.charAt(n2 + 2);
                    if ((c & 0xC0) != 128 || (c2 & 0xC0) != 128) {
                        n2 = codecs.insertReplacementAndGetResume(stringBuilder, string2, "utf-8", string, n2, n2 + 3, "invalid data");
                        continue block7;
                    }
                    if ((n3 = ((n3 & 0xF) << 12) + ((c & 0x3F) << 6) + (c2 & 0x3F)) < 2048 || n3 >= 55296 && n3 < 57344) {
                        n2 = codecs.insertReplacementAndGetResume(stringBuilder, string2, "utf-8", string, n2, n2 + 3, "illegal encoding");
                        continue block7;
                    }
                    stringBuilder.appendCodePoint(n3);
                    break;
                }
                case 4: {
                    char c = string.charAt(n2 + 1);
                    char c2 = string.charAt(n2 + 2);
                    char c3 = string.charAt(n2 + 3);
                    if ((c & 0xC0) != 128 || (c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        n2 = codecs.insertReplacementAndGetResume(stringBuilder, string2, "utf-8", string, n2, n2 + 4, "invalid data");
                        continue block7;
                    }
                    if ((n3 = ((n3 & 7) << 18) + ((c & 0x3F) << 12) + ((c2 & 0x3F) << 6) + (c3 & 0x3F)) < 65536 || n3 > 0x10FFFF) {
                        n2 = codecs.insertReplacementAndGetResume(stringBuilder, string2, "utf-8", string, n2, n2 + 4, "illegal encoding");
                        continue block7;
                    }
                    stringBuilder.appendCodePoint(n3);
                    break;
                }
                default: {
                    n2 = codecs.insertReplacementAndGetResume(stringBuilder, string2, "utf-8", string, n2, n2 + by, "unsupported Unicode code range");
                    continue block7;
                }
            }
            n2 += by;
        }
        if (nArray != null) {
            nArray[0] = n2;
        }
        return stringBuilder.toString();
    }

    public static String PyUnicode_EncodeUTF8(String string, String string2) {
        return StringUtil.fromBytes(Charset.forName("UTF-8").encode(string));
    }

    public static String PyUnicode_DecodeASCII(String string, int n, String string2) {
        return codecs.PyUnicode_DecodeIntLimited(string, n, string2, "ascii", 128);
    }

    public static String PyUnicode_DecodeLatin1(String string, int n, String string2) {
        return codecs.PyUnicode_DecodeIntLimited(string, n, string2, "latin-1", 256);
    }

    private static String PyUnicode_DecodeIntLimited(String string, int n, String string2, String string3, int n2) {
        StringBuilder stringBuilder = new StringBuilder(n);
        String string4 = "ordinal not in range(" + n2 + ")";
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < n2) {
                stringBuilder.append(c);
                continue;
            }
            i = codecs.insertReplacementAndGetResume(stringBuilder, string2, string3, string, i, i + 1, string4) - 1;
        }
        return stringBuilder.toString();
    }

    public static String PyUnicode_EncodeASCII(String string, int n, String string2) {
        return codecs.PyUnicode_EncodeIntLimited(string, n, string2, "ascii", 128);
    }

    public static String PyUnicode_EncodeLatin1(String string, int n, String string2) {
        return codecs.PyUnicode_EncodeIntLimited(string, n, string2, "latin-1", 256);
    }

    private static String PyUnicode_EncodeIntLimited(String string, int n, String string2, String string3, int n2) {
        String string4 = "ordinal not in range(" + n2 + ")";
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= n2) {
                int n3;
                for (n3 = i + 1; n3 < n && string.charAt(n3) >= n2; ++n3) {
                }
                if (string2 != null) {
                    if (string2.equals(IGNORE)) {
                        i = n3 - 1;
                        continue;
                    }
                    if (string2.equals(REPLACE)) {
                        for (int j = i; j < n3; ++j) {
                            stringBuilder.append('?');
                        }
                        i = n3 - 1;
                        continue;
                    }
                    if (string2.equals(XMLCHARREFREPLACE)) {
                        stringBuilder.append((CharSequence)codecs.xmlcharrefreplace(i, n3, string));
                        i = n3 - 1;
                        continue;
                    }
                    if (string2.equals(BACKSLASHREPLACE)) {
                        stringBuilder.append((CharSequence)codecs.backslashreplace(i, n3, string));
                        i = n3 - 1;
                        continue;
                    }
                }
                PyObject pyObject = codecs.encoding_error(string2, string3, string, i, n3, string4);
                String string5 = pyObject.__getitem__(0).toString();
                for (int j = 0; j < string5.length(); ++j) {
                    if (string5.charAt(j) < n2) continue;
                    throw Py.UnicodeEncodeError(string3, string, i + j, i + j + 1, string4);
                }
                stringBuilder.append(string5);
                i = codecs.calcNewPosition(n, pyObject) - 1;
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static int calcNewPosition(int n, PyObject pyObject) {
        int n2 = ((PyInteger)pyObject.__getitem__(1)).getValue();
        if (n2 < 0) {
            n2 = n + n2;
        }
        if (n2 > n || n2 < 0) {
            throw Py.IndexError(n2 + " out of bounds of encoded string");
        }
        return n2;
    }

    public static String PyUnicode_EncodeRawUnicodeEscape(String string, String string2, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        Iterator<Integer> iterator = new PyUnicode(string).newSubsequenceIterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            if (n >= 65536) {
                stringBuilder.append("\\U");
                stringBuilder.append(hexdigit[n >> 28 & 0xF]);
                stringBuilder.append(hexdigit[n >> 24 & 0xF]);
                stringBuilder.append(hexdigit[n >> 20 & 0xF]);
                stringBuilder.append(hexdigit[n >> 16 & 0xF]);
                stringBuilder.append(hexdigit[n >> 12 & 0xF]);
                stringBuilder.append(hexdigit[n >> 8 & 0xF]);
                stringBuilder.append(hexdigit[n >> 4 & 0xF]);
                stringBuilder.append(hexdigit[n & 0xF]);
                continue;
            }
            if (n >= 256 || bl && (n == 92 || n == 10)) {
                stringBuilder.append("\\u");
                stringBuilder.append(hexdigit[n >> 12 & 0xF]);
                stringBuilder.append(hexdigit[n >> 8 & 0xF]);
                stringBuilder.append(hexdigit[n >> 4 & 0xF]);
                stringBuilder.append(hexdigit[n & 0xF]);
                continue;
            }
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    public static String PyUnicode_DecodeRawUnicodeEscape(String string, String string2) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c != '\\') {
                stringBuilder.append(c);
                ++n2;
                continue;
            }
            int n3 = n2;
            while (n2 < n && (c = string.charAt(n2)) == '\\') {
                stringBuilder.append(c);
                ++n2;
            }
            if ((n2 - n3 & 1) == 0 || n2 >= n || c != 'u' && c != 'U') continue;
            stringBuilder.setLength(stringBuilder.length() - 1);
            int n4 = c == 'u' ? 4 : 8;
            ++n2;
            int n5 = 0;
            int n6 = -1;
            for (int i = 0; i < n4; ++i) {
                if (n2 == n) {
                    n6 = -1;
                    break;
                }
                c = string.charAt(n2);
                n6 = Character.digit(c, 16);
                if (n6 == -1) break;
                n5 = (n5 << 4 & 0xFFFFFFF0) + n6;
                ++n2;
            }
            if (n6 == -1) {
                n2 = codecs.insertReplacementAndGetResume(stringBuilder, string2, "rawunicodeescape", string, n3, n2, "truncated \\uXXXX");
                continue;
            }
            stringBuilder.appendCodePoint(n5);
        }
        return stringBuilder.toString();
    }

    public static String PyUnicode_EncodePunycode(PyUnicode pyUnicode, String string) {
        int n6;
        int n2 = 128;
        int n3 = 0;
        int n4 = 72;
        int n5 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (int n6 : pyUnicode) {
            if (!Punycode.isBasic(n6)) continue;
            stringBuilder.appendCodePoint(n6);
            ++n5;
        }
        if (n5 > 0) {
            stringBuilder.appendCodePoint(45);
        }
        int n7 = n5;
        n6 = pyUnicode.getCodePointCount();
        while (n7 < n6) {
            int n8 = Integer.MAX_VALUE;
            int n9 = 0;
            int n10 = 0;
            for (int n11 : pyUnicode) {
                if (n11 > n2 && n11 < n8) {
                    n8 = n11;
                    n10 = n9;
                }
                ++n9;
            }
            long l = n3 + (n8 - n2) * (n7 + 1);
            if (l > Integer.MAX_VALUE) {
                throw Py.UnicodeEncodeError("punycode", pyUnicode.getString(), n10, n10 + 1, "overflow");
            }
            n3 = (int)l;
            n2 = n8;
            n9 = 0;
            for (int n11 : pyUnicode) {
                if (n11 < n2) {
                    l = n3 + 1;
                    if (l > Integer.MAX_VALUE) {
                        throw Py.UnicodeEncodeError("punycode", pyUnicode.getString(), n9, n9 + 1, "overflow");
                    }
                    n3 = (int)l;
                }
                if (n11 == n2) {
                    int n12 = n3;
                    int n13 = 36;
                    while (true) {
                        int n14;
                        int n15 = n13 <= n4 ? 1 : (n14 = n13 >= n4 + 26 ? 26 : n13 - n4);
                        if (n12 < n14) break;
                        stringBuilder.appendCodePoint(n14 + (n12 - n14) % (36 - n14));
                        n12 = (n12 - n14) / (36 - n14);
                        n13 += 36;
                    }
                    stringBuilder.appendCodePoint(n12);
                    n4 = Punycode.adapt(n3, n7 + 1, n7 == n5);
                    n3 = 0;
                    ++n7;
                }
                ++n9;
            }
            ++n3;
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static PyUnicode PyUnicode_DecodePunycode(String string, String string2) {
        int n;
        int n2;
        int n3 = string.length();
        int n4 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            n = string.charAt(n2);
            if (!Punycode.isBasic(n)) {
                throw Py.UnicodeDecodeError("punycode", string, n2, n2 + 1, "not basic");
            }
            if (n == 45) break;
            arrayList.add(n);
            ++n4;
        }
        n = 128;
        int n5 = 0;
        int n6 = 72;
        while (n2 < n3) {
            int n7 = n5;
            int n8 = 1;
            int n9 = 36;
            while (true) {
                int n10;
                char c;
                int n11;
                long l;
                if ((l = (long)(n5 + (n11 = (c = string.charAt(n2++)) - 48) * n8)) > Integer.MAX_VALUE) {
                    throw Py.UnicodeDecodeError("punycode", string, n2, n2 + 1, "overflow");
                }
                n5 = (int)l;
                int n12 = n9 <= n6 ? 1 : (n10 = n9 >= n6 + 26 ? 26 : n9 - n6);
                if (n11 < n10) break;
                long l2 = n8 * 36 - n10;
                if (l2 > Integer.MAX_VALUE) {
                    throw Py.UnicodeDecodeError("punycode", string, n2, n2 + 1, "overflow");
                }
                n9 += 36;
            }
            n6 = Punycode.adapt(n5 - n7, n4 + 1, n7 == 0);
            n += n5 / (n4 + 1);
            arrayList.add(n5 %= n4 + 1, n);
        }
        return new PyUnicode(arrayList);
    }

    public static String PyUnicode_EncodeIDNA(PyUnicode pyUnicode, String string) {
        throw new UnsupportedOperationException();
    }

    public static PyUnicode PyUnicode_DecodeIDNA(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    public static PyObject encoding_error(String string, String string2, String string3, int n, int n2, String string4) {
        PyObject pyObject = codecs.lookup_error(string);
        PyException pyException = Py.UnicodeEncodeError(string2, string3, n, n2, string4);
        pyException.normalize();
        PyObject pyObject2 = pyObject.__call__(new PyObject[]{pyException.value});
        codecs.checkErrorHandlerReturn(string, pyObject2);
        return pyObject2;
    }

    public static int insertReplacementAndGetResume(StringBuilder stringBuilder, String string, String string2, String string3, int n, int n2, String string4) {
        if (string != null) {
            if (string.equals(IGNORE)) {
                return n2;
            }
            if (string.equals(REPLACE)) {
                while (n < n2) {
                    stringBuilder.appendCodePoint(Py_UNICODE_REPLACEMENT_CHARACTER);
                    ++n;
                }
                return n2;
            }
        }
        PyObject pyObject = codecs.decoding_error(string, string2, string3, n, n2, string4);
        codecs.checkErrorHandlerReturn(string, pyObject);
        stringBuilder.append(pyObject.__getitem__(0).toString());
        return codecs.calcNewPosition(string3.length(), pyObject);
    }

    public static PyObject decoding_error(String string, String string2, String string3, int n, int n2, String string4) {
        PyObject pyObject = codecs.lookup_error(string);
        PyException pyException = Py.UnicodeDecodeError(string2, string3, n, n2, string4);
        pyException.normalize();
        return pyObject.__call__(new PyObject[]{pyException.value});
    }

    private static void checkErrorHandlerReturn(String string, PyObject pyObject) {
        if (!(pyObject instanceof PyTuple && pyObject.__len__() == 2 && pyObject.__getitem__(0) instanceof PyBaseString && pyObject.__getitem__(1) instanceof PyInteger)) {
            throw new PyException(Py.TypeError, "error_handler " + string + " must return a tuple of (replacement, new position)");
        }
    }

    static {
        INIT_LOCK = new Object();
        default_encoding = "ascii";
        hexdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        utf7_special = new char[]{'\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0002', '\u0002', '\u0001', '\u0001', '\u0002', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0002', '\u0003', '\u0003', '\u0003', '\u0003', '\u0003', '\u0003', '\u0000', '\u0000', '\u0000', '\u0003', '\u0001', '\u0000', '\u0000', '\u0000', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0003', '\u0003', '\u0003', '\u0003', '\u0000', '\u0003', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0003', '\u0001', '\u0003', '\u0003', '\u0003', '\u0003', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0003', '\u0003', '\u0003', '\u0001', '\u0001'};
        utf8_code_length = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 0, 0};
        hexdigit = "0123456789ABCDEF".toCharArray();
    }

    private static class Punycode {
        private static final int BASE = 36;
        private static final int TMIN = 1;
        private static final int TMAX = 26;
        private static final int SKEW = 38;
        private static final int DAMP = 700;
        private static final int INITIAL_BIAS = 72;
        private static final int INITIAL_N = 128;
        private static final int BASIC = 128;

        private Punycode() {
        }

        private static int adapt(int n, int n2, boolean bl) {
            n = bl ? n / 700 : n >> 1;
            n += n / n2;
            int n3 = 0;
            while (n > 455) {
                n /= 35;
                n3 += 36;
            }
            return n3 + 36 * n / (n + 38);
        }

        private static boolean isBasic(int n) {
            return n < 128;
        }
    }
}

